﻿var dateTimeAnswerValidator = function () {
    var _minValue = null;
    var _maxValue = null;
    var _type = null;
    var _dateTimeFormat = null;
    var _dateFormat = null;
    var _timeFormat = null;
    var _isValid = null;
    var _errorMessage = null;

    init = function (minValue, maxValue, questionType, dateFormat, timeFormat) {
        _minValue = minValue;
        _maxValue = maxValue;
        _type = questionType;
        if (dateFormat)
            _dateFormat = dateFormat.toUpperCase();
        if (timeFormat)
            _timeFormat = timeFormat.replace(/M/g, "m").replace(/tt/g, "A");
        if (dateFormat && timeFormat)
            _dateTimeFormat = _dateFormat + " " + _timeFormat;
        validate();
    }

    validate = function () {
        _errorMessage = null;
        _isValid = null;

        switch (_type) {
            case "DateTime":
                validateMinMaxDates(_dateTimeFormat);
                break;
            case "Date":
                validateMinMaxDates(_dateFormat);
                break;
            case "Time":
                validateMinMaxDates(_timeFormat);
                break;
            case "Year":
            case "Month":
            case "Day":
            case "Hours":
            case "Minutes":
                validateMinMax(_minValue, _maxValue);
                break;
        }

        _isValid = _errorMessage === null;
    }

    validateMinMax = function () {

        if (!isStringADate(_minValue) || !isStringADate(_maxValue))
            return;

        if (!isNaN(_minValue) && !isNaN(_maxValue)) {
            if (parseInt(_minValue) > parseInt(_maxValue)) {
                _errorMessage = "Max date lower than min date";
            }
        }
        else if (_minValue > _maxValue) {
                _errorMessage = "Max date lower than min date";
        }
    }

    validateMinMaxDates = function (format) {

        if (!isStringADate(_minValue) || !isStringADate(_maxValue))
            return;

        var minDate = moment(_minValue, format, true);
        var maxDate = moment(_maxValue, format, true);

        if (!minDate.isValid())
            _errorMessage = "Min. Value " + _minValue + " is not formatted properly " + format;
        else if (!maxDate.isValid())
            _errorMessage = "Max. Value " + _maxValue + " is not formatted properly " + format;
        else if (minDate > maxDate)
            _errorMessage = "Max date lower than min date";
        
    }

    isStringADate = function (val) {
        return val && val != "" && !valueContainsVariable(val) && val != "TodayValue";
    }

    valueContainsVariable = function (val) {
        return val.indexOf("[") > -1;
    }

    return {
        init: init,
        isValid: function () {
            return _isValid;
        },
        errorMessage: function () {
            return _errorMessage;
        }
    }
}